//This file is part of LiveCoding1. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file LiveCoding1.help

LCAudioCapture1
{
classvar fftbuf;
var l, tempoclock, numchan, <buf, <sf, <beats, <time, <onsets, <durations;

*initClass{

StartUp.add({

SynthDef.writeOnce("lcmonorec",{ arg i_bus=0, i_bufnum, running=1.0, trigger=0.0; 
//doesn't need Out, just runs
RecordBuf.ar(InFeedback.ar(i_bus), i_bufnum, 0, 1.0, 0.0, running, 0.0, trigger);
});

SynthDef.writeOnce("lcstereorec",{ arg i_bus=0, i_bufnum, running=1.0, trigger=0.0; 
//doesn't need Out, just runs
RecordBuf.ar(InFeedback.ar([i_bus,i_bus+1]), i_bufnum, 0, 1.0, 0.0, running, 0.0, trigger);
});

	
SynthDef.writeOnce(\lcmonorechf,
{
arg i_bus=0, i_bufnum, running=1.0, trigger=0.0, i_fftbufnum, threshold=0.7, retrigtime=0.05;
 var source, proc, test, trig, diff, trig2, test2, combine;
	
	source= InFeedback.ar(i_bus); 
	
	RecordBuf.ar(source, i_bufnum, 0, 1.0, 0.0, running, 0.0, trigger);

	SendTrig.ar(Impulse.ar(0), 1, 1);
	
	proc= PV_HainsworthFoote.ar(FFT(i_fftbufnum,source),0.75,0.25,threshold,retrigtime);
	
	trig= Trig1.ar(proc-0.3, 0.005);

	SendTrig.ar(trig, 0, proc);
	
});

});

}


*new
{
arg l, numchan=1, beats=8;

^super.new.initLCAudioCapture1(l, numchan, beats);
}


initLCAudioCapture1
{
arg livecoding1obj, nc=1, bts=8;

l=livecoding1obj;
tempoclock= l.tempoclock;
numchan=nc;
beats=bts;

time= ((tempoclock.tempo).reciprocal)*beats;

//mono
buf=Buffer.alloc(Server.default, 44100*time, numchan);
 
sf= SF3.newFromBuf(buf, beats, 44100);

fftbuf=Buffer.alloc(Server.default,1024,1);

}

//
//record
//{
//arg bus; 
//var recorder;
//
//tempoclock.schedAbs(l.tempocontrol.nextbar,{
//
//recorder= 
//
//if(numchan<2,
//
//{Synth(\lcmonorec,[\i_bus, bus, \i_bufnum, buf.bufnum, \running, 1.0, \trigger, 1.0]);},
//{Synth(\lcstereorec,[\i_bus, bus, \i_bufnum, buf.bufnum, \running, 1.0, \trigger, 1.0]);}); 
//
////schedule trig to zero so its ready again
//tempoclock.sched(beats, {recorder.free; nil});
//
//nil
//});
//
//}

//unaccurate if tempo changed during bar 
record
{
arg bus; 
var nodenum, time, tr;

tr=(tempoclock.tempo).reciprocal;

//LCTempoControl TempoClock
time= tr*((l.tempocontrol.nextbar)-(l.tempoclock.elapsedBeats));

time=0.0;
nodenum=Server.default.nextNodeID;

Server.default.sendBundle(time, ["/s_new", if(numchan<2,{"lcmonorec"},{"lcstereorec"}), nodenum , 1, 0, \i_bus, bus, \i_bufnum, buf.bufnum, \running, 1.0, \trigger, 1.0]);

Server.default.sendBundle(time+(tr*beats), ["/n_free",nodenum]);

}


recordonsets
{
arg bus, threshold=0.7; 
var nodenum, time, tr, start,s, responder, nw, len;

s=Server.default;
onsets=List.new;	
durations=List.new;	

nw=0;

tr=(tempoclock.tempo).reciprocal;
len=(tr*beats); //bufferlength in seconds

responder=OSCresponderNode(s.addr,'/tr',{ arg tim,responder,msg;
var siz;
if(nw==0,{start=tim; nw=1;},
{
onsets.add(tim-start); //in seconds, can correct to beats via tempo as you go
	
siz=onsets.size;	
if(siz>1,{durations.add(onsets[siz-1]-onsets[siz-2])});	

//update as you go
sf.setKnown(((onsets/len)*(sf.numFrames)).round(1.0).asInteger, durations++[0.1]);
});

//Post << [onsets,durations]<<nl;
}).add;	
		

//LCTempoControl TempoClock
//trigger at next bar start
time= tr*((l.tempocontrol.nextbar)-(l.tempoclock.elapsedBeats));

//time=0.0;
nodenum=s.nextNodeID;

s.sendBundle(time, ["/s_new", "lcmonorechf", nodenum , 1, 0, \i_bus, bus, \i_bufnum, buf.bufnum, \running, 1.0, \trigger, 1.0, \i_fftbufnum, fftbuf.bufnum, \threshold, threshold]);

time=time+len;

s.sendBundle(time, ["/n_free",nodenum]);

//cleanup responder and last duration value
SystemClock.sched(time+0.1,{

if(onsets.notEmpty,{durations.add(time-onsets[onsets.size-1])},{onsets=[0]; durations=[0.1]});	
sf.setKnown(((onsets/len)*(sf.numFrames)).round(1.0).asInteger, durations);

responder.remove;});

}


write
{
arg path; 

path = path ? ("audiocapture"++(buf.bufnum.asString)++".aiff");

buf.write(path,"aiff","int16"); 

}

}